function [Data,Time,Meta]=ACQUIRE_FILE_GET(FileName,Offset,NumVals,Meta)
% function [Data,Time,Meta]=ACQUIRE_FILE_GET(FileName,Offset,NumVals,Meta)
% If Offsett is -ve then take from end of file
% Meta is and optional argument - it allows repeated reads from file without re-interpreting meta data
% The meta data is n Octave text format and terminated with a NULL 0 
% This allows for arbitrary additions to Meta data in future
%
% Ian Stothers Mar 2021
% To Do 
% - perhaps better change of Meta detection
% 

% Meta change and end of file detection
  fh=fopen(FileName,"rb");
  fseek(fh,0,"eof");
  fend=ftell(fh);
  fclose(fh);
  MetaChange=1;
  if (exist("Meta")==1)
    if (min(size(Meta))>0)
      if(((fend-Meta.end)>=0))
       MetaChange=0;
      end      
    endif
  endif

 
  if ((nargin<4)||(MetaChange==1)||(min(size(Meta))<1))
   fh=fopen(FileName,"rb");
   z=[]; 
   c=[];
   while (min(size(z))<1)
    c=[c fread(fh,1000,"char")];
    z=find(c==0);
   end
   fclose(fh);
   z=min(z);
   tfn=char(floor(26*rand(10,1))+'A')';  
   fh=fopen(tfn,"wb");
   fwrite(fh,c(1:(z-1)),"char"); 
   fclose(fh);
   load( tfn);  % Get Meta
   delete(tfn);
   Meta.z=z;
   Meta.end=fend;
  endif % load Meta data 
  Meta.end=fend;
  z=Meta.z;
  nchan=double(Meta.NumChan);
  DT=double(Meta.DeltaT);
  fh=fopen(FileName,"r");
  NSampFrame=floor((fend-z)/(4*nchan));
  if (Offset<0)
    NumVals=min([NSampFrame NumVals]);
    Offset=NSampFrame-NumVals; 
  endif
  NumVals=min([NumVals NSampFrame-Offset]);
  if (NumVals>0)
   fseek(fh,z+Offset*4*nchan);
   Data=fread(fh,NumVals*nchan,"single");
   if (prod(size(Data))==NumVals*nchan)
    Data=reshape(Data,nchan,NumVals);
    Time=double(DT*double(double(Offset)+double(0:(NumVals-1))));
%     Time=double(DT*double(0:(NumVals-1)));
   else
    Data=[];
    Time=[];
   endif
  else
   Data=[];
   Time=[];
  endif 
  fclose(fh);
end  